<?php
/**
 * Hash Test
 * GET /api/auth/hash-test?password=test123
 */

require_once '../../../spam/helpers.php';
require_once '../../../spam/cache_config.php';

setCorsHeaders();
setCacheNone();
setJsonHeader();

$password = $_GET['password'] ?? 'test123';

$startTime = microtime(true);
$hash = hash('sha256', $password);
$hashTime = microtime(true) - $startTime;

sendSuccess([
    'password' => $password,
    'hash' => $hash,
    'hash_length' => strlen($hash),
    'hash_time' => round($hashTime * 1000, 2) . 'ms',
    'php_version' => phpversion(),
], 'Hash test successful');
?>
