<?php
/**
 * Simple Login (Username only, no password check)
 * POST /api/auth/login-simple
 * FOR TESTING ONLY!
 */

require_once '../../../spam/db_config.php';
require_once '../../../spam/cache_config.php';
require_once '../../../spam/helpers.php';

setCorsHeaders();
setCacheNone();
setJsonHeader();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendError('Method not allowed', 405);
}

try {
    $startTime = microtime(true);

    $data = getJsonBody();
    $username = $data['username'] ?? null;

    if (!$username) {
        sendError('Missing username', 400);
    }

    error_log('[LoginSimple] Looking for user: ' . $username);

    // Just find user by username (NO password check)
    $sql = "
        SELECT
            id, username, created_at, status,
            premium_status, premium_expires_at, premium_started_at, plan_type
        FROM users
        WHERE username = :username
        LIMIT 1
    ";

    $result = dbQuery($sql, ['username' => $username]);

    if (empty($result)) {
        error_log('[LoginSimple] User not found: ' . $username);
        sendError('User not found', 404);
    }

    $user = $result[0];

    if ($user['status'] !== 'active') {
        sendError('Account is disabled', 403);
    }

    // Generate session token
    $sessionToken = generateSessionToken();

    $totalTime = microtime(true) - $startTime;

    error_log('[LoginSimple] Success in ' . round($totalTime * 1000, 2) . 'ms');

    sendSuccess([
        'user' => [
            'id' => (int)$user['id'],
            'username' => $user['username'],
            'created_at' => $user['created_at'],
            'premium_status' => $user['premium_status'] ?? 'free',
            'premium_expires_at' => $user['premium_expires_at'],
            'premium_started_at' => $user['premium_started_at'],
            'plan_type' => $user['plan_type'] ?? 'free',
        ],
        'session_token' => $sessionToken,
        'debug_timing' => [
            'total_time' => round($totalTime * 1000, 2) . 'ms'
        ]
    ], 'Simple login successful (NO PASSWORD CHECK - TESTING ONLY)');

} catch (Exception $e) {
    error_log('[LoginSimple] Exception: ' . $e->getMessage());
    sendError('Server error: ' . $e->getMessage(), 500);
}
?>
