<?php
/**
 * Test Database Connection
 * GET /api/auth/test-db
 */

require_once '../../../spam/db_config.php';
require_once '../../../spam/cache_config.php';
require_once '../../../spam/helpers.php';

// Set headers
setCorsHeaders();
setCacheNone();
setJsonHeader();

try {
    $startTime = microtime(true);

    // Test 1: Check if we can connect to database
    $pdo = getDbConnection();
    $connectionTime = microtime(true) - $startTime;

    // Test 2: Query users table
    $queryStartTime = microtime(true);
    $sql = "SELECT COUNT(*) as count FROM users";
    $result = dbQuery($sql, []);
    $queryTime = microtime(true) - $queryStartTime;

    $userCount = $result[0]['count'] ?? 0;

    // Test 3: Check if specific user exists
    $userCheckTime = microtime(true);
    $sql = "SELECT id, username FROM users LIMIT 1";
    $users = dbQuery($sql, []);
    $userCheckDuration = microtime(true) - $userCheckTime;

    $totalTime = microtime(true) - $startTime;

    sendSuccess([
        'database_connected' => true,
        'total_users' => (int)$userCount,
        'sample_user' => $users[0] ?? null,
        'timing' => [
            'connection_time' => round($connectionTime * 1000, 2) . 'ms',
            'count_query_time' => round($queryTime * 1000, 2) . 'ms',
            'user_query_time' => round($userCheckDuration * 1000, 2) . 'ms',
            'total_time' => round($totalTime * 1000, 2) . 'ms'
        ]
    ], 'Database connection test successful');

} catch (Exception $e) {
    error_log('[TestDB] Error: ' . $e->getMessage());
    sendError('Database error: ' . $e->getMessage(), 500);
}
?>
