<?php
/**
 * Test Login WITHOUT Password Check
 * GET /api/auth/test-login?username=abit4662
 */

require_once '../../../spam/db_config.php';
require_once '../../../spam/cache_config.php';
require_once '../../../spam/helpers.php';

setCorsHeaders();
setCacheNone();
setJsonHeader();

try {
    $username = getParam('username');

    if (!$username) {
        sendError('Missing username parameter', 400);
    }

    $startTime = microtime(true);

    // Test 1: Find user by username only (no password check)
    $sql = "
        SELECT
            id, username, password_hash, created_at, last_login, status,
            premium_status, premium_expires_at, premium_started_at, plan_type
        FROM users
        WHERE username = :username
        LIMIT 1
    ";

    $result = dbQuery($sql, ['username' => $username]);
    $queryTime = microtime(true) - $startTime;

    if (empty($result)) {
        sendError('User not found', 404);
    }

    $user = $result[0];

    // Test 2: Hash a test password
    $hashStart = microtime(true);
    $testPassword = 'test123';
    $testHash = hashPassword($testPassword);
    $hashTime = microtime(true) - $hashStart;

    $totalTime = microtime(true) - $startTime;

    sendSuccess([
        'user_found' => true,
        'user' => [
            'id' => (int)$user['id'],
            'username' => $user['username'],
            'status' => $user['status'],
            'password_hash_length' => strlen($user['password_hash']),
            'password_hash_preview' => substr($user['password_hash'], 0, 20) . '...',
        ],
        'test_hash' => [
            'password' => $testPassword,
            'hash' => $testHash,
            'hash_length' => strlen($testHash),
        ],
        'timing' => [
            'query_time' => round($queryTime * 1000, 2) . 'ms',
            'hash_time' => round($hashTime * 1000, 2) . 'ms',
            'total_time' => round($totalTime * 1000, 2) . 'ms',
        ]
    ], 'User found');

} catch (Exception $e) {
    error_log('[TestLogin] Error: ' . $e->getMessage());
    sendError('Server error: ' . $e->getMessage(), 500);
}
?>
