<?php
/**
 * Session Validation Endpoint
 * GET /api/auth/validate?session_token=xxx
 */

require_once '../../../spam/db_config.php';
require_once '../../../spam/cache_config.php';
require_once '../../../spam/helpers.php';

// Set headers
setCorsHeaders();
setCacheNone(); // Never cache authentication
setJsonHeader();

// Only allow GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendError('Method not allowed', 405);
}

try {
    $sessionToken = getParam('session_token');

    if (!$sessionToken) {
        sendError('Missing session_token parameter', 400);
    }

    // Check if session exists and is valid
    $sql = "
        SELECT
            s.user_id, s.expires_at,
            u.username, u.status,
            u.premium_status, u.premium_expires_at, u.plan_type
        FROM user_sessions s
        JOIN users u ON u.id = s.user_id
        WHERE s.session_token = :token
        AND s.expires_at > CURRENT_TIMESTAMP
        AND u.status = 'active'
    ";

    $result = dbQuery($sql, ['token' => $sessionToken]);

    if (empty($result)) {
        sendError('Invalid or expired session', 401);
    }

    $session = $result[0];

    // Return valid session info
    sendSuccess([
        'valid' => true,
        'user' => [
            'id' => (int)$session['user_id'],
            'username' => $session['username'],
            'premium_status' => $session['premium_status'] ?? 'free',
            'premium_expires_at' => $session['premium_expires_at'],
            'plan_type' => $session['plan_type'] ?? 'free',
        ],
        'expires_at' => $session['expires_at']
    ]);

} catch (Exception $e) {
    error_log('[Validate] Error: ' . $e->getMessage());
    sendError('Server error: ' . $e->getMessage(), 500);
}
?>
