<?php
/**
 * Clear PHP OpCache
 */

header('Content-Type: application/json');

$result = [
    'opcache_enabled' => function_exists('opcache_reset'),
    'opcache_reset' => false,
    'timestamp' => time()
];

if (function_exists('opcache_reset')) {
    $result['opcache_reset'] = opcache_reset();
    $result['opcache_status'] = opcache_get_status();
}

// Also clear any realpath cache
clearstatcache(true);
$result['clearstatcache'] = true;

echo json_encode($result, JSON_PRETTY_PRINT);
?>
