<?php
/**
 * Get Anime Endpoint
 * GET /api/content/anime?language=de&limit=20&offset=0
 * VERSION: 2024-10-17-FIXED
 */

require_once '../../../spam/db_config.php';
require_once '../../../spam/cache_config.php';
require_once '../../../spam/helpers.php';

setCorsHeaders();
setCacheLong();
setJsonHeader();

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendError('Method not allowed', 405);
}

try {
    $language = getParam('language', 'de');
    $limit = min((int)getParam('limit', 20), 100);
    $offset = max((int)getParam('offset', 0), 0);

    $sourceSites = getAnimeSitesByLanguage($language);
    $sourceSitesStr = "'" . implode("','", $sourceSites) . "'";

    $sql = "
        SELECT id, title, description, cover_url, rating,
               source_site, year, genres, alternative_titles,
               created_at, updated_at
        FROM animes
        WHERE source_site IN ($sourceSitesStr)
        AND status = 'completed'
        ORDER BY updated_at DESC
        LIMIT :limit OFFSET :offset
    ";

    // Bind parameters as integers for PostgreSQL
    $stmt = getDbConnection(true)->prepare($sql);
    $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();
    $results = $stmt->fetchAll();
    $anime = array_map('contentFromRow', $results);

    sendSuccess([
        'items' => $anime,
        'count' => count($anime),
        'limit' => $limit,
        'offset' => $offset,
        'language' => $language,
        '_version' => '2024-10-17-FIXED'
    ]);

} catch (Exception $e) {
    error_log('[Anime] Error: ' . $e->getMessage());
    sendError('Server error: ' . $e->getMessage(), 500);
}
?>
