<?php
/**
 * Anime Detailed Debug - Microsecond Timing
 * VERSION: 2024-10-17-DEBUG-MICROSECONDS
 */

function logTime($label) {
    global $timings;
    $timings[] = [
        'label' => $label,
        'time' => microtime(true),
        'memory' => memory_get_usage()
    ];
}

$timings = [];
logTime('START');

require_once '../../../spam/db_config.php';
logTime('AFTER require db_config.php');

require_once '../../../spam/cache_config.php';
logTime('AFTER require cache_config.php');

require_once '../../../spam/helpers.php';
logTime('AFTER require helpers.php');

setCorsHeaders();
logTime('AFTER setCorsHeaders()');

setCacheLong();
logTime('AFTER setCacheLong()');

setJsonHeader();
logTime('AFTER setJsonHeader()');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendError('Method not allowed', 405);
}
logTime('AFTER method check');

try {
    $language = getParam('language', 'de');
    logTime('AFTER getParam language');

    $limit = min((int)getParam('limit', 20), 100);
    logTime('AFTER getParam limit');

    $offset = max((int)getParam('offset', 0), 0);
    logTime('AFTER getParam offset');

    $sourceSites = getAnimeSitesByLanguage($language);
    logTime('AFTER getAnimeSitesByLanguage()');

    $sourceSitesStr = "'" . implode("','", $sourceSites) . "'";
    logTime('AFTER implode sourceSites');

    $sql = "
        SELECT id, title, description, cover_url, rating,
               source_site, year, genres, alternative_titles,
               created_at, updated_at
        FROM animes
        WHERE source_site IN ($sourceSitesStr)
        AND status = 'completed'
        ORDER BY updated_at DESC
        LIMIT :limit OFFSET :offset
    ";
    logTime('AFTER SQL string build');

    // Bind parameters as integers for PostgreSQL
    $pdo = getDbConnection(true);
    logTime('AFTER getDbConnection()');

    $stmt = $pdo->prepare($sql);
    logTime('AFTER prepare()');

    $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
    logTime('AFTER bindValue limit');

    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    logTime('AFTER bindValue offset');

    $stmt->execute();
    logTime('AFTER execute()');

    $results = $stmt->fetchAll();
    logTime('AFTER fetchAll() - rows: ' . count($results));

    $anime = array_map('contentFromRow', $results);
    logTime('AFTER array_map contentFromRow');

    // Calculate timings
    $processedTimings = [];
    for ($i = 1; $i < count($timings); $i++) {
        $prev = $timings[$i - 1];
        $curr = $timings[$i];
        $duration = ($curr['time'] - $prev['time']) * 1000;
        $processedTimings[] = [
            'step' => $curr['label'],
            'duration_ms' => round($duration, 3),
            'memory_mb' => round($curr['memory'] / 1024 / 1024, 2)
        ];
    }

    $totalTime = round(($timings[count($timings) - 1]['time'] - $timings[0]['time']) * 1000, 2);

    sendSuccess([
        'items' => $anime,
        'count' => count($anime),
        'limit' => $limit,
        'offset' => $offset,
        'language' => $language,
        '_debug' => [
            'version' => '2024-10-17-DEBUG-MICROSECONDS',
            'total_time_ms' => $totalTime,
            'timings' => $processedTimings
        ]
    ]);

} catch (Exception $e) {
    logTime('EXCEPTION: ' . $e->getMessage());

    $processedTimings = [];
    for ($i = 1; $i < count($timings); $i++) {
        $prev = $timings[$i - 1];
        $curr = $timings[$i];
        $duration = ($curr['time'] - $prev['time']) * 1000;
        $processedTimings[] = [
            'step' => $curr['label'],
            'duration_ms' => round($duration, 3)
        ];
    }

    error_log('[Anime Debug] Error: ' . $e->getMessage());
    sendError('Server error: ' . $e->getMessage() . ' | Timings: ' . json_encode($processedTimings), 500);
}
?>
