<?php
/**
 * Check which version of movies.php is loaded
 */

header('Content-Type: application/json');

$moviesPath = __DIR__ . '/movies.php';
$moviesContent = file_get_contents($moviesPath);

// Check for version string
$hasVersion = strpos($moviesContent, '2024-10-16-OPTIMIZED') !== false;

// Check for key indicators
$checks = [
    'has_version_comment' => $hasVersion,
    'file_exists' => file_exists($moviesPath),
    'file_size' => filesize($moviesPath),
    'file_modified' => date('Y-m-d H:i:s', filemtime($moviesPath)),
    'first_100_chars' => substr($moviesContent, 0, 200),
];

echo json_encode($checks, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
?>
