<?php
/**
 * OpCache Clear Tool
 * URL: https://buy-business-manager.com/api/content/clear_cache.php
 */

header('Content-Type: application/json');

$result = [
    'success' => false,
    'message' => 'OpCache is not enabled',
    'timestamp' => time()
];

if (function_exists('opcache_reset')) {
    if (opcache_reset()) {
        $result['success'] = true;
        $result['message'] = 'OpCache cleared successfully';

        // Get OpCache status
        if (function_exists('opcache_get_status')) {
            $status = opcache_get_status();
            $result['opcache_status'] = [
                'enabled' => $status['opcache_enabled'] ?? false,
                'cache_full' => $status['cache_full'] ?? false,
                'restart_pending' => $status['restart_pending'] ?? false,
                'restart_in_progress' => $status['restart_in_progress'] ?? false
            ];
        }
    } else {
        $result['message'] = 'Failed to clear OpCache';
    }
}

echo json_encode($result, JSON_PRETTY_PRINT);
?>
