<?php
/**
 * Get Content Detail by ID
 * GET /api/content/detail?id=123
 *
 * OPTIMIZED: Increased cache duration to 4 hours (recommended for content details)
 * Performance: Simple query on animes table (no optimization needed)
 * VERSION: 2024-10-17-OPCACHE-BUSTER
 */

require_once '../../../spam/db_config.php';
require_once '../../../spam/cache_config.php';
require_once '../../../spam/helpers.php';

setCorsHeaders();
// Increased from 2h to 4h (14400s) - content details change rarely
setCacheDynamic(240); // 240 minutes = 4 hours
setJsonHeader();

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendError('Method not allowed', 405);
}

try {
    $id = (int)getParam('id');

    if ($id <= 0) {
        sendError('Invalid content ID', 400);
    }

    // Simple query on animes table - already fast (< 10ms)
    // No materialized view needed for single-row lookup by primary key
    $sql = "
        SELECT id, title, description, cover_url, rating,
               source_site, year, genres, alternative_titles,
               created_at, updated_at
        FROM animes
        WHERE id = :id
        LIMIT 1
    ";

    $results = dbQuery($sql, ['id' => $id]);

    if (empty($results)) {
        sendError('Content not found', 404);
    }

    $content = contentFromRow($results[0]);

    // Add version tag
    $content['_version'] = '2024-10-17-OPCACHE-BUSTER';

    sendSuccess($content);

} catch (Exception $e) {
    error_log('[Detail] Error: ' . $e->getMessage());
    sendError('Server error: ' . $e->getMessage(), 500);
}
?>
