<?php
/**
 * Get Most Popular Content
 * GET /api/content/most-popular?language=de
 */

require_once '../../../spam/db_config.php';
require_once '../../../spam/cache_config.php';
require_once '../../../spam/helpers.php';

setCorsHeaders();
setCacheDynamic(120); // Cache for 2 hours (120 minutes)
setJsonHeader();

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendError('Method not allowed', 405);
}

try {
    $language = getParam('language', 'de');
    $sourceSite = getParam('source_site', null);

    // If source_site is provided, use only that site. Otherwise use all sites.
    if ($sourceSite) {
        $sourceSites = [$sourceSite];
    } else {
        $sourceSites = getAllSourceSitesByLanguage($language);
    }
    $sourceSitesStr = "'" . implode("','", $sourceSites) . "'";

    // Use materialized view if exists
    $sql = "
        SELECT
            mv.id, mv.title, mv.description, mv.cover_url, mv.average_rating as rating,
            mv.source_site, mv.year, mv.genres, NULL as alternative_titles,
            NULL as created_at, NULL as updated_at
        FROM mv_most_popular mv
        WHERE mv.source_site IN ($sourceSitesStr)
        ORDER BY mv.favorites_count DESC
        LIMIT 20
    ";

    // Fallback if mv doesn't exist
    $fallbackSql = "
        SELECT id, title, description, cover_url, rating,
               source_site, year, genres, alternative_titles,
               created_at, updated_at
        FROM animes
        WHERE source_site IN ($sourceSitesStr)
        AND status = 'completed'
        AND rating >= 6.0
        ORDER BY rating DESC, updated_at DESC
        LIMIT 20
    ";

    try {
        $results = dbQuery($sql, []);
    } catch (Exception $e) {
        $results = dbQuery($fallbackSql, []);
    }

    $content = array_map('contentFromRow', $results);

    sendSuccess(['items' => $content, 'count' => count($content)]);

} catch (Exception $e) {
    error_log('[MostPopular] Error: ' . $e->getMessage());
    sendError('Server error: ' . $e->getMessage(), 500);
}
?>
