<?php
/**
 * Get Movies Endpoint - FINAL OPTIMIZED VERSION
 * VERSION: 2024-10-17-ABSOLUTELY-FINAL
 */

$startTime = microtime(true);

require_once '../../../spam/db_config.php';
require_once '../../../spam/cache_config.php';
require_once '../../../spam/helpers.php';

setCorsHeaders();
setCacheLong();
setJsonHeader();

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendError('Method not allowed', 405);
}

try {
    $language = getParam('language', 'de');
    $limit = min((int)getParam('limit', 20), 100);
    $offset = max((int)getParam('offset', 0), 0);
    $orderBy = getParam('orderBy', 'updated_at');

    $allowedOrderBy = ['updated_at', 'created_at', 'rating', 'title'];
    if (!in_array($orderBy, $allowedOrderBy)) {
        $orderBy = 'updated_at';
    }

    $sourceSites = getMovieSitesByLanguage($language);
    $sourceSitesStr = "'" . implode("','", $sourceSites) . "'";

    $sql = "
        SELECT
            id, title, description, cover_url, rating,
            source_site, year, genres, alternative_titles,
            created_at, updated_at
        FROM animes
        WHERE source_site IN ($sourceSitesStr)
        AND status = 'completed'
        ORDER BY $orderBy DESC
        LIMIT :limit OFFSET :offset
    ";

    // Use PgBouncer with integer parameter binding
    $pdo = getDbConnection(true);
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();
    $results = $stmt->fetchAll();

    $movies = array_map('contentFromRow', $results);

    $totalTime = round((microtime(true) - $startTime) * 1000, 2);

    sendSuccess([
        'items' => $movies,
        'count' => count($movies),
        'limit' => $limit,
        'offset' => $offset,
        'language' => $language,
        '_debug' => [
            'version' => '2024-10-17-ABSOLUTELY-FINAL',
            'execution_time_ms' => $totalTime,
            'rows_fetched' => count($results),
            'using_pgbouncer' => true
        ]
    ]);

} catch (Exception $e) {
    error_log('[Movies V2] Error: ' . $e->getMessage());
    sendError('Server error: ' . $e->getMessage(), 500);
}
?>
