<?php
/**
 * Search Content
 * GET /api/content/search?q=breaking&language=de
 */

require_once '../../../spam/db_config.php';
require_once '../../../spam/cache_config.php';
require_once '../../../spam/helpers.php';

setCorsHeaders();
setCacheDynamic(15); // Cache for 15 minutes
setJsonHeader();

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendError('Method not allowed', 405);
}

try {
    $query = getParam('q', '');
    $language = getParam('language');

    if (strlen($query) < 2) {
        sendSuccess(['items' => [], 'count' => 0]);
        exit;
    }

    $searchPattern = '%' . $query . '%';

    $sql = "
        SELECT id, title, description, cover_url, rating,
               source_site, year, genres, alternative_titles,
               created_at, updated_at
        FROM animes
        WHERE status = 'completed'
        AND (
            title ILIKE :pattern
            OR alternative_titles::text ILIKE :pattern
        )
    ";

    $params = ['pattern' => $searchPattern];

    // Add language filter if provided
    if ($language !== null) {
        $sourceSites = getAllSourceSitesByLanguage($language);
        $sourceSitesStr = "'" . implode("','", $sourceSites) . "'";
        $sql .= " AND source_site IN ($sourceSitesStr)";
    }

    $sql .= "
        ORDER BY
            CASE WHEN title ILIKE :pattern THEN 0 ELSE 1 END,
            rating DESC NULLS LAST
        LIMIT 50
    ";

    $results = dbQuery($sql, $params);
    $content = array_map('contentFromRow', $results);

    sendSuccess([
        'items' => $content,
        'count' => count($content),
        'query' => $query
    ]);

} catch (Exception $e) {
    error_log('[Search] Error: ' . $e->getMessage());
    sendError('Server error: ' . $e->getMessage(), 500);
}
?>
