<?php
/**
 * DEBUG VERSION - Get Trending Content
 * Shows detailed error messages
 */

// Show errors (ONLY FOR DEBUG!)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');

try {
    echo json_encode(['step' => 1, 'message' => 'Starting...']) . "\n";

    require_once '../../../spam/db_config.php';
    echo json_encode(['step' => 2, 'message' => 'Config loaded']) . "\n";

    require_once '../../../spam/cache_config.php';
    echo json_encode(['step' => 3, 'message' => 'Cache config loaded']) . "\n";

    require_once '../../../spam/helpers.php';
    echo json_encode(['step' => 4, 'message' => 'Helpers loaded']) . "\n";

    setCorsHeaders();
    echo json_encode(['step' => 5, 'message' => 'CORS set']) . "\n";

    setCacheDynamic(10);
    echo json_encode(['step' => 6, 'message' => 'Cache set']) . "\n";

    $language = getParam('language', 'de');
    echo json_encode(['step' => 7, 'message' => 'Language: ' . $language]) . "\n";

    $sourceSites = getAllSourceSitesByLanguage($language);
    echo json_encode(['step' => 8, 'message' => 'Source sites: ' . json_encode($sourceSites)]) . "\n";

    $sourceSitesStr = "'" . implode("','", $sourceSites) . "'";
    echo json_encode(['step' => 9, 'message' => 'Sites string: ' . $sourceSitesStr]) . "\n";

    $sql = "
        SELECT id, title, description, cover_url, rating,
               source_site, year, genres, alternative_titles,
               created_at, updated_at
        FROM animes
        WHERE source_site IN ($sourceSitesStr)
        AND status = 'completed'
        ORDER BY updated_at DESC, rating DESC NULLS LAST
        LIMIT 20
    ";
    echo json_encode(['step' => 10, 'message' => 'SQL prepared']) . "\n";

    $results = dbQuery($sql, []);
    echo json_encode(['step' => 11, 'message' => 'Query executed, rows: ' . count($results)]) . "\n";

    $trending = array_map('contentFromRow', $results);
    echo json_encode(['step' => 12, 'message' => 'Content mapped: ' . count($trending)]) . "\n";

    sendSuccess(['items' => $trending, 'count' => count($trending)]);

} catch (Exception $e) {
    echo json_encode([
        'error' => true,
        'message' => $e->getMessage(),
        'file' => $e->getFile(),
        'line' => $e->getLine(),
        'trace' => $e->getTraceAsString()
    ], JSON_PRETTY_PRINT);
}
?>
