<?php
/**
 * Get Trending Content
 * GET /api/content/trending?language=de
 */

require_once '../../../spam/db_config.php';
require_once '../../../spam/cache_config.php';
require_once '../../../spam/helpers.php';

setCorsHeaders();
setCacheDynamic(120); // Cache for 2 hours (120 minutes)
setJsonHeader();

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendError('Method not allowed', 405);
}

try {
    $language = getParam('language', 'de');
    $sourceSite = getParam('source_site', null);

    // If source_site is provided, use only that site. Otherwise use all sites.
    if ($sourceSite) {
        $sourceSites = [$sourceSite];
    } else {
        $sourceSites = getAllSourceSitesByLanguage($language);
    }
    $sourceSitesStr = "'" . implode("','", $sourceSites) . "'";

    $sql = "
        SELECT id, title, description, cover_url, rating,
               source_site, year, genres, alternative_titles,
               created_at, updated_at
        FROM animes
        WHERE source_site IN ($sourceSitesStr)
        AND status = 'completed'
        ORDER BY updated_at DESC, rating DESC NULLS LAST
        LIMIT 20
    ";

    $results = dbQuery($sql, []);
    $trending = array_map('contentFromRow', $results);

    sendSuccess(['items' => $trending, 'count' => count($trending)]);

} catch (Exception $e) {
    error_log('[Trending] Error: ' . $e->getMessage());
    sendError('Server error: ' . $e->getMessage(), 500);
}
?>
