<?php
/**
 * Database Connection Debug Tool
 * URL: https://buy-business-manager.com/api/db-connection-test.php
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);
header('Content-Type: application/json');

$result = [
    'server_ip' => $_SERVER['SERVER_ADDR'] ?? 'Unknown',
    'tests' => []
];

// Test 1: Can we reach VPS via socket?
$result['tests']['socket_test'] = [
    'description' => 'Test if VPS is reachable on port 25 (forwarded to 6432)',
    'status' => 'unknown'
];

$host = '176.123.2.53';
$port = 25; // Port forwarding 25 -> 6432
$timeout = 5;

$startTime = microtime(true);
$socket = @fsockopen($host, $port, $errno, $errstr, $timeout);
$endTime = microtime(true);

if ($socket) {
    fclose($socket);
    $result['tests']['socket_test']['status'] = 'SUCCESS';
    $result['tests']['socket_test']['message'] = 'VPS is reachable on port 25 (forwarded to 6432)';
    $result['tests']['socket_test']['time_ms'] = round(($endTime - $startTime) * 1000, 2);
} else {
    $result['tests']['socket_test']['status'] = 'FAILED';
    $result['tests']['socket_test']['error_code'] = $errno;
    $result['tests']['socket_test']['error_message'] = $errstr;
    $result['tests']['socket_test']['time_ms'] = round(($endTime - $startTime) * 1000, 2);
}

// Test 2: Try to connect with PDO (detailed error)
$result['tests']['pdo_test'] = [
    'description' => 'Try PDO connection to PostgreSQL',
    'status' => 'unknown'
];

try {
    $dsn = "pgsql:host=176.123.2.53;port=25;dbname=application_db;sslmode=disable"; // Port forwarding 25 -> 6432
    $user = 'dbadmin_prod';
    $pass = 'y7jOt+8tHdc9fblM/p0arfbWtsfVaYFhYTb93bWeCmE=';

    $startTime = microtime(true);
    $pdo = new PDO($dsn, $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_TIMEOUT => 5
    ]);
    $endTime = microtime(true);

    $result['tests']['pdo_test']['status'] = 'SUCCESS';
    $result['tests']['pdo_test']['message'] = 'PDO connection successful';
    $result['tests']['pdo_test']['time_ms'] = round(($endTime - $startTime) * 1000, 2);

    // Test query
    $stmt = $pdo->query('SELECT 1 as test');
    $queryResult = $stmt->fetch();
    $result['tests']['pdo_test']['query_test'] = $queryResult ? 'SUCCESS' : 'FAILED';

} catch (PDOException $e) {
    $endTime = microtime(true);
    $result['tests']['pdo_test']['status'] = 'FAILED';
    $result['tests']['pdo_test']['error'] = $e->getMessage();
    $result['tests']['pdo_test']['error_code'] = $e->getCode();
    $result['tests']['pdo_test']['time_ms'] = round(($endTime - $startTime) * 1000, 2);
}

// Test 3: Check if PostgreSQL extension works
$result['tests']['extension_test'] = [
    'pdo_pgsql_loaded' => extension_loaded('pdo_pgsql'),
    'pgsql_loaded' => extension_loaded('pgsql'),
    'pdo_drivers' => PDO::getAvailableDrivers()
];

// Test 4: DNS Resolution
$result['tests']['dns_test'] = [
    'description' => 'Resolve 176.123.2.53',
    'ip' => gethostbyname('176.123.2.53')
];

// Test 5: Network Info
$result['network_info'] = [
    'php_version' => phpversion(),
    'allow_url_fopen' => ini_get('allow_url_fopen'),
    'default_socket_timeout' => ini_get('default_socket_timeout'),
];

echo json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
?>
