<?php
/**
 * Debug version of seasons.php with timing for each step
 */

$scriptStart = microtime(true);
$timings = [];

// Step 1: Require files
$step = microtime(true);
require_once '../../../spam/db_config.php';
$timings['require_db_config'] = (microtime(true) - $step) * 1000;

$step = microtime(true);
require_once '../../../spam/cache_config.php';
$timings['require_cache_config'] = (microtime(true) - $step) * 1000;

$step = microtime(true);
require_once '../../../spam/helpers.php';
$timings['require_helpers'] = (microtime(true) - $step) * 1000;

// Step 2: Set headers
$step = microtime(true);
setCorsHeaders();
$timings['setCorsHeaders'] = (microtime(true) - $step) * 1000;

$step = microtime(true);
setCacheDynamic(360);
$timings['setCacheDynamic'] = (microtime(true) - $step) * 1000;

$step = microtime(true);
setJsonHeader();
$timings['setJsonHeader'] = (microtime(true) - $step) * 1000;

// Step 3: Method check
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendError('Method not allowed', 405);
}

try {
    // Step 4: Get parameters
    $step = microtime(true);
    $contentId = (int)getParam('content_id');
    $timings['getParam'] = (microtime(true) - $step) * 1000;

    if ($contentId <= 0) {
        sendError('Invalid content_id', 400);
    }

    // Step 5: DB Query
    $step = microtime(true);
    $sql = "
        SELECT season_number, episode_count, first_episode, last_episode
        FROM mv_content_seasons
        WHERE content_id = :content_id
        ORDER BY season_number ASC
    ";
    $results = dbQuery($sql, ['content_id' => $contentId]);
    $timings['dbQuery'] = (microtime(true) - $step) * 1000;

    // Step 6: Process results
    $step = microtime(true);
    if (empty($results)) {
        sendSuccess(['seasons' => [1]]);
        exit;
    }

    $seasons = array_map(function($row) {
        return (int)$row['season_number'];
    }, $results);
    $timings['array_map'] = (microtime(true) - $step) * 1000;

    // Step 7: Send response
    $step = microtime(true);
    $response = [
        'success' => true,
        'data' => [
            'seasons' => $seasons,
            'count' => count($seasons)
        ],
        'debug' => [
            'timings' => $timings,
            'total_ms' => round((microtime(true) - $scriptStart) * 1000, 3)
        ],
        'timestamp' => time()
    ];

    header('Content-Type: application/json');
    echo json_encode($response);
    $timings['json_encode'] = (microtime(true) - $step) * 1000;

} catch (Exception $e) {
    error_log('[Seasons Debug] Error: ' . $e->getMessage());
    sendError('Server error: ' . $e->getMessage(), 500);
}

$timings['total_script'] = (microtime(true) - $scriptStart) * 1000;
?>
