<?php
/**
 * Test which db_config.php is being loaded by episodes.php
 */

header('Content-Type: application/json');

// Show which file would be required
$configPath = realpath(__DIR__ . '/../../../spam/db_config.php');

$result = [
    'current_file' => __FILE__,
    'current_dir' => __DIR__,
    'config_path_relative' => '../../../spam/db_config.php',
    'config_path_resolved' => $configPath,
    'config_exists' => file_exists($configPath),
];

if (file_exists($configPath)) {
    $result['config_file_size'] = filesize($configPath);
    $result['config_file_modified'] = date('Y-m-d H:i:s', filemtime($configPath));

    // Read first 50 lines to check for DB_PORT_PGBOUNCER
    $lines = file($configPath);
    $result['config_first_50_lines'] = array_slice($lines, 0, 50);

    // Check if new constants exist
    $content = file_get_contents($configPath);
    $result['has_DB_PORT_DIRECT'] = strpos($content, 'DB_PORT_DIRECT') !== false;
    $result['has_DB_PORT_PGBOUNCER'] = strpos($content, 'DB_PORT_PGBOUNCER') !== false;
    $result['has_ATTR_PERSISTENT_false'] = strpos($content, 'ATTR_PERSISTENT => false') !== false;
}

echo json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
?>
