<?php
/**
 * Error Handler for API
 * Handles 404, 500, and other HTTP errors
 */

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-cache, no-store, must-revalidate');

$errorCode = isset($_GET['code']) ? (int)$_GET['code'] : 500;
$requestUri = $_SERVER['REQUEST_URI'] ?? 'unknown';
$method = $_SERVER['REQUEST_METHOD'] ?? 'unknown';

$errors = [
    400 => 'Bad Request',
    401 => 'Unauthorized',
    403 => 'Forbidden',
    404 => 'Not Found',
    405 => 'Method Not Allowed',
    429 => 'Too Many Requests',
    500 => 'Internal Server Error',
    503 => 'Service Unavailable',
];

$errorMessage = $errors[$errorCode] ?? 'Unknown Error';

http_response_code($errorCode);

echo json_encode([
    'success' => false,
    'error' => $errorMessage,
    'code' => $errorCode,
    'request' => [
        'method' => $method,
        'uri' => $requestUri
    ],
    'timestamp' => time()
], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);

// Log error
error_log(sprintf(
    '[API Error] %d %s - %s %s',
    $errorCode,
    $errorMessage,
    $method,
    $requestUri
));
?>
