<?php
/**
 * API Index / Documentation
 * GET /api/
 *
 * Displays available endpoints and API information
 */

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: public, max-age=3600');

$apiInfo = [
    'api_name' => 'KinoApp API',
    'version' => '1.0',
    'status' => 'operational',
    'base_url' => 'https://kinoapp.stream/api',
    'documentation' => 'https://kinoapp.stream/api/docs',
    'timestamp' => time(),

    'endpoints' => [
        'Authentication' => [
            'POST /api/auth/register' => 'Register new user',
            'POST /api/auth/login' => 'Login user',
            'GET /api/auth/validate' => 'Validate session token',
        ],

        'Content' => [
            'GET /api/content/movies' => 'Get movies (params: language, limit, offset, orderBy)',
            'GET /api/content/series' => 'Get series (params: language, limit, offset, orderBy)',
            'GET /api/content/anime' => 'Get anime (params: language, limit, offset)',
            'GET /api/content/detail' => 'Get content by ID (param: id)',
            'GET /api/content/trending' => 'Get trending content (param: language)',
            'GET /api/content/recently-updated' => 'Get recently updated (param: language)',
            'GET /api/content/most-popular' => 'Get most popular (param: language)',
            'GET /api/content/search' => 'Search content (params: q, language)',
        ],

        'Episodes' => [
            'GET /api/episodes/seasons' => 'Get available seasons (param: content_id)',
            'GET /api/episodes/episodes' => 'Get episodes (params: content_id, season)',
        ],

        'Premium' => [
            'POST /api/premium/voucher-submit' => 'Submit voucher code',
            'GET /api/premium/voucher-list' => 'Get user vouchers (param: user_id)',
            'GET /api/premium/premium-status' => 'Get premium status (param: user_id)',
        ],

        'User' => [
            'GET /api/user/favorites' => 'Get favorites (param: user_id)',
            'POST /api/user/favorites' => 'Add to favorites (body: user_id, content_id)',
            'DELETE /api/user/favorites' => 'Remove from favorites (params: user_id, content_id)',
        ],
    ],

    'rate_limits' => [
        'requests_per_minute' => 100,
        'burst' => 20,
    ],

    'cache_strategy' => [
        'static_content' => '2 hours',
        'dynamic_content' => '5-15 minutes',
        'user_specific' => 'no cache',
    ],

    'support' => [
        'email' => 'support@kinoapp.stream',
        'github' => 'https://github.com/kinoapp/api',
    ],
];

echo json_encode($apiInfo, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
?>
