<?php
/**
 * Get Premium Status for User
 * GET /api/premium/premium-status?user_id=123
 */

require_once '../../../spam/db_config.php';
require_once '../../../spam/cache_config.php';
require_once '../../../spam/helpers.php';

setCorsHeaders();
setCacheNone(); // User-specific data
setJsonHeader();

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendError('Method not allowed', 405);
}

try {
    $userId = (int)getParam('user_id');

    if ($userId <= 0) {
        sendError('Invalid user_id', 400);
    }

    $sql = "
        SELECT premium_status, premium_expires_at, premium_started_at, plan_type
        FROM users
        WHERE id = :user_id
    ";

    $results = dbQuery($sql, ['user_id' => $userId]);

    if (empty($results)) {
        sendError('User not found', 404);
    }

    $user = $results[0];

    sendSuccess([
        'premium_status' => $user['premium_status'] ?? 'free',
        'premium_expires_at' => $user['premium_expires_at'],
        'premium_started_at' => $user['premium_started_at'],
        'plan_type' => $user['plan_type'] ?? 'free'
    ]);

} catch (Exception $e) {
    error_log('[PremiumStatus] Error: ' . $e->getMessage());
    sendError('Server error: ' . $e->getMessage(), 500);
}
?>
