<?php
/**
 * Get User Vouchers
 * GET /api/premium/voucher-list?user_id=123
 */

require_once '../../../spam/db_config.php';
require_once '../../../spam/cache_config.php';
require_once '../../../spam/helpers.php';

setCorsHeaders();
setCacheNone(); // User-specific data
setJsonHeader();

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendError('Method not allowed', 405);
}

try {
    $userId = (int)getParam('user_id');

    if ($userId <= 0) {
        sendError('Invalid user_id', 400);
    }

    $sql = "
        SELECT id, user_id, voucher_code, voucher_type, plan_name, plan_price,
               plan_duration, status, admin_notes, submitted_at, reviewed_at, reviewed_by
        FROM voucher_submissions
        WHERE user_id = :user_id
        ORDER BY submitted_at DESC
    ";

    $results = dbQuery($sql, ['user_id' => $userId]);

    $vouchers = array_map(function($row) {
        return [
            'id' => (int)$row['id'],
            'user_id' => (int)$row['user_id'],
            'voucher_code' => $row['voucher_code'],
            'voucher_type' => $row['voucher_type'],
            'plan_name' => $row['plan_name'],
            'plan_price' => $row['plan_price'],
            'plan_duration' => $row['plan_duration'],
            'status' => $row['status'],
            'admin_notes' => $row['admin_notes'],
            'submitted_at' => $row['submitted_at'],
            'reviewed_at' => $row['reviewed_at'],
            'reviewed_by' => $row['reviewed_by'] ? (int)$row['reviewed_by'] : null
        ];
    }, $results);

    sendSuccess(['items' => $vouchers, 'count' => count($vouchers)]);

} catch (Exception $e) {
    error_log('[VoucherList] Error: ' . $e->getMessage());
    sendError('Server error: ' . $e->getMessage(), 500);
}
?>
