<?php
/**
 * Submit Voucher Code
 * POST /api/premium/voucher-submit
 *
 * Body: {
 *   "user_id": 123,
 *   "voucher_code": "ABC123",
 *   "voucher_type": "azteco",
 *   "plan_name": "1 Jahr Premium",
 *   "plan_price": "25,00 €",
 *   "plan_duration": "1 Jahr"
 * }
 */

require_once '../../../spam/db_config.php';
require_once '../../../spam/cache_config.php';
require_once '../../../spam/helpers.php';

setCorsHeaders();
setCacheNone(); // Never cache voucher submissions
setJsonHeader();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendError('Method not allowed', 405);
}

try {
    $data = getJsonBody();

    $validation = validateParams([
        'user_id', 'voucher_code', 'voucher_type',
        'plan_name', 'plan_price', 'plan_duration'
    ], $data);

    if ($validation !== true) {
        sendError($validation, 400);
    }

    $sql = "
        INSERT INTO voucher_submissions
        (user_id, voucher_code, voucher_type, plan_name, plan_price, plan_duration, status, submitted_at)
        VALUES (:user_id, :voucher_code, :voucher_type, :plan_name, :plan_price, :plan_duration, 'pending', CURRENT_TIMESTAMP)
        RETURNING id
    ";

    $result = dbQuery($sql, [
        'user_id' => (int)$data['user_id'],
        'voucher_code' => sanitizeInput($data['voucher_code']),
        'voucher_type' => sanitizeInput($data['voucher_type']),
        'plan_name' => sanitizeInput($data['plan_name']),
        'plan_price' => sanitizeInput($data['plan_price']),
        'plan_duration' => sanitizeInput($data['plan_duration'])
    ]);

    if (empty($result)) {
        sendError('Failed to submit voucher', 500);
    }

    sendSuccess([
        'voucher_id' => (int)$result[0]['id']
    ], 'Voucher submitted successfully');

} catch (Exception $e) {
    error_log('[VoucherSubmit] Error: ' . $e->getMessage());
    sendError('Server error: ' . $e->getMessage(), 500);
}
?>
