<?php
/**
 * Get User Rating for Content
 * GET /api/ratings/user-rating?user_id=1&content_id=123
 *
 * Note: content_id maps to anime_id in the database
 * Rating scale: 1-5 stars
 */

require_once '../../../spam/db_config.php';
require_once '../../../spam/cache_config.php';
require_once '../../../spam/helpers.php';

setCorsHeaders();
setCacheNone(); // Don't cache user-specific data
setJsonHeader();

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendError('Method not allowed', 405);
}

try {
    $userId = (int)getParam('user_id');
    $contentId = (int)getParam('content_id');

    if ($userId <= 0 || $contentId <= 0) {
        sendError('Invalid user_id or content_id', 400);
    }

    // Check if user has rated this content (using anime_id)
    $sql = "
        SELECT rating
        FROM user_ratings
        WHERE user_id = :user_id AND anime_id = :anime_id
        LIMIT 1
    ";

    $result = dbQuery($sql, [
        'user_id' => $userId,
        'anime_id' => $contentId
    ]);

    if (empty($result)) {
        // User has not rated this content
        sendSuccess([
            'has_rated' => false,
            'rating' => null
        ], 'No rating found');
    } else {
        // User has rated this content
        sendSuccess([
            'has_rated' => true,
            'rating' => (int)$result[0]['rating']
        ], 'Rating found');
    }

} catch (Exception $e) {
    error_log('[UserRating] Error: ' . $e->getMessage());
    sendError('Server error: ' . $e->getMessage(), 500);
}
?>
