<?php
/**
 * Test Direct Connection Speed to VPS Database
 */

header('Content-Type: application/json');

$host = '176.123.2.53';
$port = 6432; // PgBouncer
$dbname = 'application_db';
$user = 'dbadmin_prod';
$password = 'y7jOt+8tHdc9fblM/p0arfbWtsfVaYFhYTb93bWeCmE=';

$results = [];

// Test 1: Socket connection time
$start = microtime(true);
$socket = @fsockopen($host, $port, $errno, $errstr, 5);
$socketTime = (microtime(true) - $start) * 1000;

if ($socket) {
    fclose($socket);
    $results['socket_test'] = [
        'status' => 'success',
        'time_ms' => round($socketTime, 3),
        'port' => $port
    ];
} else {
    $results['socket_test'] = [
        'status' => 'failed',
        'error' => "$errstr ($errno)",
        'time_ms' => round($socketTime, 3),
        'port' => $port
    ];
}

// Test 2: PDO connection time (NO persistent)
$start = microtime(true);
try {
    $dsn = "pgsql:host=$host;port=$port;dbname=$dbname;sslmode=disable";
    $options = [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_PERSISTENT => false, // NON-PERSISTENT
        PDO::ATTR_TIMEOUT => 5,
    ];
    $pdo = new PDO($dsn, $user, $password, $options);
    $pdoTime = (microtime(true) - $start) * 1000;

    $results['pdo_connection'] = [
        'status' => 'success',
        'time_ms' => round($pdoTime, 3),
        'persistent' => false
    ];

    // Test 3: Simple query
    $start = microtime(true);
    $stmt = $pdo->query("SELECT 1");
    $queryTime = (microtime(true) - $start) * 1000;

    $results['simple_query'] = [
        'status' => 'success',
        'time_ms' => round($queryTime, 3)
    ];

} catch (PDOException $e) {
    $pdoTime = (microtime(true) - $start) * 1000;
    $results['pdo_connection'] = [
        'status' => 'failed',
        'error' => $e->getMessage(),
        'time_ms' => round($pdoTime, 3)
    ];
}

// Test 4: PDO connection time (PERSISTENT) - OLD WAY
$start = microtime(true);
try {
    $dsn = "pgsql:host=$host;port=$port;dbname=$dbname;sslmode=disable";
    $options = [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_PERSISTENT => true, // PERSISTENT (OLD)
        PDO::ATTR_TIMEOUT => 5,
    ];
    $pdo2 = new PDO($dsn, $user, $password, $options);
    $pdoTime2 = (microtime(true) - $start) * 1000;

    $results['pdo_persistent'] = [
        'status' => 'success',
        'time_ms' => round($pdoTime2, 3),
        'persistent' => true,
        'note' => 'This is the OLD way that causes 20s delay'
    ];

} catch (PDOException $e) {
    $pdoTime2 = (microtime(true) - $start) * 1000;
    $results['pdo_persistent'] = [
        'status' => 'failed',
        'error' => $e->getMessage(),
        'time_ms' => round($pdoTime2, 3)
    ];
}

echo json_encode([
    'success' => true,
    'host' => $host,
    'port' => $port,
    'tests' => $results,
    'timestamp' => time()
], JSON_PRETTY_PRINT);
?>
