<?php
/**
 * Test DB Config - Verify which db_config.php is loaded
 */

require_once '../../../spam/db_config.php';

header('Content-Type: application/json');

// Test DB connection and report settings
try {
    $pdo = getDbConnection();

    // Get connection info
    $info = [
        'status' => 'connected',
        'db_host' => DB_HOST,
        'db_port_direct' => defined('DB_PORT_DIRECT') ? DB_PORT_DIRECT : 'NOT DEFINED',
        'db_port_pgbouncer' => defined('DB_PORT_PGBOUNCER') ? DB_PORT_PGBOUNCER : 'NOT DEFINED',
        'db_name' => DB_NAME,
        'config_file_loaded' => __DIR__ . '/../../../spam/db_config.php',
        'php_version' => phpversion(),
        'timestamp' => time(),
    ];

    // Quick query test
    $start = microtime(true);
    $stmt = $pdo->query("SELECT COUNT(*) FROM animes WHERE status = 'completed'");
    $count = $stmt->fetchColumn();
    $queryTime = (microtime(true) - $start) * 1000; // Convert to ms

    $info['test_query'] = [
        'query' => "SELECT COUNT(*) FROM animes WHERE status = 'completed'",
        'result' => $count,
        'time_ms' => round($queryTime, 3),
    ];

    echo json_encode([
        'success' => true,
        'data' => $info
    ], JSON_PRETTY_PRINT);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'trace' => $e->getTraceAsString()
    ], JSON_PRETTY_PRINT);
}
?>
